/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ConfigLockDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 26.07.06 10:19 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Configuration Lock Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        25.07.2006  MT       initial version
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConfigLockeDlg.h
///   Configuration Lock Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// Configuration Lock Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CConfigLockDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CConfigLockDlg)

public:
	CConfigLockDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CConfigLockDlg();

// Dialog Data
	enum { IDD = IDD_CONFIGLOCK };

protected:
  unsigned long   m_ulSetTimeout;   //!< Timeout when calling Set Host State
  CComboBox       m_cNewStateCtrl;  //!< Set Host State Combobox Control

  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);
};
